package etradeproject;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */

public class updateprofile extends HttpServlet
{
  static final private String CONTENT_TYPE = "text/html; charset=windows-1251";
  //Initialize global variables
  public void init() throws ServletException
  {
  }

  private String getParameter(HttpServletRequest request, String name)
  {
    if(request.getParameter(name)==null || request.getParameter(name.trim()).equals(""))
      return null;

    return request.getParameter(name);
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    request.setCharacterEncoding("windows-1251");
    response.setContentType(CONTENT_TYPE);

    User user = (User) request.getSession().getAttribute("user");

    String firstName = getParameter(request, "firstName");
    String lastName = getParameter(request, "lastName");
    String city = getParameter(request, "city");
    String address = getParameter(request, "address");
    String email = getParameter(request, "email");
    String userName = getParameter(request, "userName");
    String password1 = getParameter(request, "password1");
    String password2 = getParameter(request, "password2");

    if(firstName==null || userName==null ||
       (password1==null && password2!=null) ||
       (password1!=null && password2==null) ||
       (password1!=null && password2!=null && !password1.equals(password2)))
    {
      request.getSession().setAttribute("errorValue", "          !");

      response.sendRedirect("profile.jsp?error=true"
                            + (firstName!=null?"&firstName=" + firstName:"")
                            + (lastName!=null?"&lastName=" + lastName:"")
                            + (city!=null?"&city=" + city:"")
                            + (address!=null?"&address=" + address:"")
                            + (email!=null?"&email=" + email:"")
                            + (userName!=null?"&userName=" + userName:"")
                            );
      return;
    }

    if(password1==null)
      password1 = user.getPassword();

    try
    {
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      Connection con = DriverManager.getConnection("jdbc:odbc:storeDB", "sa", "");

      // Some kind of transaction - transaction ends on con.commit() method.
      con.setAutoCommit(false);

      Statement stmt = con.createStatement();

      ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE user_id <> " + user.getUserId() + " AND user_name = '" + userName + "'");

      if(rs.next())
      {
        con.commit();
        rs.close();
        stmt.close();
        con.close();

        request.getSession().setAttribute("errorValue", "      !   !");

        response.sendRedirect("profile.jsp?error=true"
                              + (firstName!=null?"&firstName=" + firstName:"")
                              + (lastName!=null?"&lastName=" + lastName:"")
                              + (city!=null?"&city=" + city:"")
                              + (address!=null?"&address=" + address:"")
                              + (email!=null?"&email=" + email:"")
                              + (userName!=null?"&userName=" + userName:"")
                              );

        return;
      }

      /*
        Bad update
      stmt.executeUpdate("UPDATE Users " +
                         "SET first_name = '" + firstName + "' " +
                         (lastName==null?"":", last_name = '" + lastName + "' ") +
                         (city==null?"":", city = '" + city + "' ") +
                         (address==null?"":", address = '" + address + "' ") +
                         (email==null?"":", e_mail = '" + email + "' ") +
                         ", user_name = '" + userName + "' " +
                         (password1==null?"":", password = '" + password1 + "' ") +
                         "WHERE user_id = " + user.getUserId());
      */

      // Good way to update
      PreparedStatement st =
          con.prepareStatement("UPDATE Users SET first_name = ?, last_name = ?, city = ?, address = ?, e_mail = ?, user_name = ?, password = ? WHERE user_id = ?");

      st.setObject(1, firstName, Types.VARCHAR);
      if(lastName==null)
        st.setNull(2, Types.VARCHAR);
      else
        st.setObject(2, lastName, Types.VARCHAR);
      if(city==null)
        st.setNull(3, Types.VARCHAR);
      else
        st.setObject(3, city, Types.VARCHAR);
      if(address==null)
        st.setNull(4, Types.VARCHAR);
      else
        st.setObject(4, address, Types.VARCHAR);
      if(email==null)
        st.setNull(5, Types.VARCHAR);
      else
        st.setObject(5, email, Types.VARCHAR);
      st.setObject(6, userName, Types.VARCHAR);
      st.setObject(7, password1, Types.VARCHAR);
      st.setObject(8, new Integer(user.getUserId()), Types.INTEGER);

      st.execute();
      st.close();

      con.commit(); // end of transaction

      user = new User(user.getUserId(), firstName, lastName,
                      city, address, email, userName, password1);

      request.getSession().setAttribute("user", user);

      rs.close();
      stmt.close();
      con.close();
    }
    catch (Exception ex)
    {
      request.getSession().setAttribute("errorValue", "  : " + ex.toString() + "!");
    }

    Cookie userCookie = new Cookie("userName", java.net.URLEncoder.encode(user.getUserName()));
    userCookie.setMaxAge(60*60*24*30); //time to  expire - 30 days
    response.addCookie(userCookie);

    response.sendRedirect("index.jsp");
  }
  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    doGet(request, response);
  }
  //Clean up resources
  public void destroy()
  {
  }
}